/************************************************************************
* (c) Copyright Freescale Semiconductor, Inc 2010, All Rights Reserved  *
*************************************************************************

************************************************************************
*                                                                      *
*        Standard Software Flash Driver For FTFL           		         *
*                                                                      *
* FILE NAME     :  GetEEEConfig.c                                      *
* DATE          :  June 11,2010                                        *
*                                                                      *
* AUTHOR        :  FPT Team                                            *
* E-mail        :  b28216@freescale.com                                *
*                                                                      *
************************************************************************/

/************************** CHANGES ***********************************
0.0.1    	06.09.2010    	FPT Team            		Initial Version
0.1.0    	06.11.2010    	FPT Team            		Finalize to 0.1.0 
***********************************************************************/

/* include the header files */
#include "SSD_Types.h"
#include "SSD_FTFL.h"
#include "SSD_FTFL_Internal.h"

/************************************************************************
*
*  Function Name    : GetEEEConfig.c
*  Description      : This function is used to read information about
*					            D/E-Flash and EERAM configuration.
*  Arguments        : PFLASH_SSD_CONFIG, UINT8*, UINT8*, pFLASHCOMMANDSEQUENCE
*  Return Value     : UINT32
*
*************************************************************************/

UINT32 GetEEEConfig(PFLASH_SSD_CONFIG PSSDConfig, \
												UINT8* EEEDataSize, \
												UINT8* DEPartitionCode, \
												pFLASHCOMMANDSEQUENCE FlashCommandSequence)
{
	UINT32 returnCode;       /* return code variable */
	UINT8 commandArray[9];
		
	/* set the default return code as FTFL_OK */
  returnCode = FTFL_OK;
	
	commandArray[0] = FTFL_READ_RESOURCE;
	commandArray[1] = (UINT8)(DFLASH_IFR_LONGWORD_ADDRESS >> 16);
	commandArray[2] = (UINT8)((DFLASH_IFR_LONGWORD_ADDRESS >> 8) & 0xFF);
	commandArray[3] = (UINT8)(DFLASH_IFR_LONGWORD_ADDRESS & 0xFF);
	commandArray[8] = 0x00;
	
	/* calling flash command sequence API to execute the command */
	returnCode = FlashCommandSequence(PSSDConfig, 8, commandArray);
	
	/* checking for the success of command execution */
	if(FTFL_OK != returnCode)
	{
		goto EXIT;
	}
	else
	{
		/* do nothing */
	}
	
	/* Read and store EEE Data Set Size and D/E-Flash Partition Code */
	*EEEDataSize = REG_READ(PSSDConfig->ftflRegBase + FTFL_FCCOB6_OFFSET);
	*DEPartitionCode = REG_READ(PSSDConfig->ftflRegBase + FTFL_FCCOB7_OFFSET);
	
EXIT:
    /* Enter Debug state if enabled */
    if (TRUE == (PSSDConfig->DebugEnable))
    {
         asm
         (
          debughlt           /* enter Debug state */
         );
    }
    
    return(returnCode);
}
/* end of file */